
##########################################################################
# Source
##########################################################################
source("TreeClone_fn.R")
source("TreeClone_plot.R")

##########################################################################
# Command line arguments
##########################################################################
args = commandArgs(TRUE)

if (length(args)==0) {
  stop("Must specify command line arguments: input file path, suffix, T (number of samples), K (number of mutation pairs).")
}

input_file = args[1]
suffix = args[2]
T = as.numeric(args[3])
K = as.numeric(args[4])


##########################################################################
# Hyperparameters
##########################################################################
hp = NULL
hp$alpha = 0.5
hp$beta = 0.5
hp$d = 0.5
hp$d0 = 0.03
hp$d1 = 1
b = 0.95

burn_in = 3000
niter = 30000
C_min = 2
C_max = 7

patent_str_list = list()
patent_str_list[[1]] = c("0")
patent_str_list[[2]] = c("01")
patent_str_list[[3]] = c("011", "012")
patent_str_list[[4]] = c("0111", "0112", "0122", "0123")
patent_str_list[[5]] = c("01111", "01112", "01122", "01123", "01124", 
                         "01222", "01223", "01233", "01234")
patent_str_list[[6]] = c("011111", "012111", "012141", "012211", "012311", 
                         "012215", "012315", "012221", "012321", "012331", 
                         "012341", "012222", "012322", "012325", "012332", 
                         "012342", "012333", "012343", "012344", "012345")
patent_str_list[[7]] = c("0111111", "0121111", "0121411", "0121416", "0122111", 
                         "0123111", "0122151", "0123151", "0122155", "0122156",
                         "0123156", "0122211", "0123211", "0123311", "0123411", 
                         "0122216", "0123216", "0123316", "0123416", "0122221", 
                         "0123221", "0123251", "0123321", "0123421", "0123331", 
                         "0123431", "0123441", "0123451", "0122222", "0123222",
                         "0123252", "0123322", "0123422", "0123326", "0123426", 
                         "0123332", "0123432", "0123442", "0123452", "0123333", 
                         "0123433", "0123436", "0123443", "0123453", "0123444",
                         "0123454", "0123455", "0123456")


parent_str_all = c()
for(cc in C_min:C_max){
  parent_str_all = c(parent_str_all, patent_str_list[[cc]])
}

##########################################################################
# Run !!
##########################################################################
TreeClone_runPT(input_file, suffix, parent_str_all)
TreeClone_MCMC(input_file, T, K, hp, b, niter, burn_in, parent_str_all, suffix = suffix)




