
#include "stdio.h"
#include "assert.h"
#include "math.h"
#include "stdlib.h"
#include "string.h"
#include "iostream"
#include "omp.h"
#include "gsl/gsl_rng.h"
#include "gsl/gsl_randist.h"


#define RNG_SEED 523531

//#define MAX_TREE_NODE	5
#define MAX_TREE_NODE	7

#define MAX_CHARS_PER_STATE	11

#define MAX_TEMP 8
#define MAX_MCMC_ITERATION 30000

#define MAX_N_STR	50
#define	MAX_STR_LEN	10



/***************************************************
Functions for finding possible tree states
***************************************************/

// hashTable[i] stores all characters that correspond to state i for a node in the tree
const char hashTable[MAX_TREE_NODE][MAX_CHARS_PER_STATE] = {"a", "abc", "abcdefg", "abcdefghi", "abcdefghij", "abcdefghij", "abcdefghij"};

int findState(char ch)
{
	if(ch == 'a')
		return 0;
	if(ch == 'b' || ch == 'c')
		return 1;
	if(ch == 'd' || ch == 'e' || ch == 'f' || ch == 'g')
		return 2;	
	if(ch == 'h' || ch == 'i')
		return 3;
	if(ch == 'j')
		return 4;
	else
		return -1;
}
 
 
// A recursive function to print all possible words that can be obtained
// by input number[] of size n.  The output words are one by one stored in output[]
void  genWordsRecur(int* number, int curr_digit, char output[], int n, char** treeStateCharMat)
{
    // Base case, if current output word is prepared
    unsigned int i;
	static int cnt;
    if (curr_digit == n)
    {
        //fprintf(stdout,"%s ", output);
		unsigned int k = strlen(output);
		//fprintf(stdout,"%d\n",k);
		for(i=0;i<k;i++)
			treeStateCharMat[cnt][i] = output[i]; 
		treeStateCharMat[cnt][k] = '\0';
		cnt++;

		//fprintf(stdout,"%d\t", cnt);		
        return ;
    }
 
    // Try all MAX_TREE_NODE possible nodes for current tree in number[] and recur for remaining state
    for (i=0; i<strlen(hashTable[number[curr_digit]]); i++)
    {
        output[curr_digit] = hashTable[number[curr_digit]][i];
        genWordsRecur(number, curr_digit+1, output, n, treeStateCharMat);
    }
}
 
// Thiscreates an output array and calls the recursive routine
void genWords(int* parentArr, int n, char** treeStateCharMat)
{
    char result[n+1];
    result[n] ='\0';
    genWordsRecur(parentArr, 0, result, n, treeStateCharMat);
}



// returns 0 if the number combination is not a valid tree
// returns 1 if the number combination is a valid tree
int validTree(char* treeToChk,int* parentArr,int n)
{
	int i,k;
	int ph1,ph2,ph3,ph4;
	int sameSt1,sameSt2,sameSt3,sameSt4;
	int sameSt5,sameSt6,sameSt7,sameSt8;
	int sameSt9,sameSt10,sameSt11,sameSt12;
	int sameSt13,sameSt14,sameSt15,sameSt16;
    
	for(i=(n-1);i>=1;i--)
	{
		k = (findState(treeToChk[i]) - findState(treeToChk[parentArr[i]-1]));

		ph1 = (int)(treeToChk[i] == 'g' && treeToChk[parentArr[i]-1] == 'b');
		ph2 = (int)(treeToChk[i] == 'e' && treeToChk[parentArr[i]-1] == 'c');
		ph3 = (int)(treeToChk[i] == 'i' && treeToChk[parentArr[i]-1] == 'e');
		ph4 = (int)(treeToChk[i] == 'h' && treeToChk[parentArr[i]-1] == 'g');

		sameSt1 = (int)(treeToChk[i] == 'b' && treeToChk[parentArr[i]-1] == 'c');
		sameSt2 = (int)(treeToChk[i] == 'c' && treeToChk[parentArr[i]-1] == 'b');
		sameSt3 = (int)(treeToChk[i] == 'h' && treeToChk[parentArr[i]-1] == 'i');
		sameSt4 = (int)(treeToChk[i] == 'i' && treeToChk[parentArr[i]-1] == 'h');
		sameSt5 = (int)(treeToChk[i] == 'd' && treeToChk[parentArr[i]-1] == 'e');
		sameSt6 = (int)(treeToChk[i] == 'd' && treeToChk[parentArr[i]-1] == 'f');
		sameSt7 = (int)(treeToChk[i] == 'd' && treeToChk[parentArr[i]-1] == 'g');
		sameSt8 = (int)(treeToChk[i] == 'e' && treeToChk[parentArr[i]-1] == 'd');
		sameSt9 = (int)(treeToChk[i] == 'e' && treeToChk[parentArr[i]-1] == 'f');
		sameSt10 = (int)(treeToChk[i] == 'e' && treeToChk[parentArr[i]-1] == 'g');
		sameSt11 = (int)(treeToChk[i] == 'f' && treeToChk[parentArr[i]-1] == 'd');
		sameSt12 = (int)(treeToChk[i] == 'f' && treeToChk[parentArr[i]-1] == 'e');
		sameSt13 = (int)(treeToChk[i] == 'f' && treeToChk[parentArr[i]-1] == 'g');
		sameSt14 = (int)(treeToChk[i] == 'g' && treeToChk[parentArr[i]-1] == 'd');
		sameSt15 = (int)(treeToChk[i] == 'g' && treeToChk[parentArr[i]-1] == 'e');
		sameSt16 = (int)(treeToChk[i] == 'g' && treeToChk[parentArr[i]-1] == 'f');
		
        
		if( (k > 1) || (k < 0) ||((ph1==1)||(ph2==1)||(ph3==1)||(ph4==1)) || 
					((sameSt1 == 1)||(sameSt2 == 1)||(sameSt3 == 1) || (sameSt4 == 1) ||  
					 (sameSt5 == 1)||(sameSt6 == 1)||(sameSt7 == 1) || (sameSt8 == 1) ||   
					 (sameSt9 == 1)||(sameSt10 == 1)||(sameSt11 == 1) || (sameSt12 == 1) ||    
					 (sameSt13 == 1)||(sameSt14 == 1)||(sameSt15 == 1) || (sameSt16 == 1) )) 

			return 0;
	}	

	return 1;
}



void getAllCombinations(int* parentArr,int n,int*** treeStateMat,int*** treeCntMat, int* m,int *m2)
{
// m is the number of valid combinations
// m2 is the number of all possible combinations
    int i,j,k;
	int N_combinations = 1;


	for(i=0;i<n;i++)
		N_combinations *= strlen(hashTable[parentArr[i]]); 	

	*m2 = N_combinations;
    
	char** treeStateCharMat;
	treeStateCharMat = (char**)(calloc(N_combinations,sizeof(char*)));
	for(i=0;i<N_combinations;i++)
		treeStateCharMat[i] = (char*)(calloc((n+1),sizeof(char)));
    /*
	*treeStateMat = (int**)(calloc(N_combinations,sizeof(int*)));
	*treeCntMat = (int**)(calloc(N_combinations,sizeof(int*)));
	for(i=0;i<N_combinations;i++)
	{		
		(*treeStateMat)[i] = (int*)(calloc((n+1),sizeof(int)));
		(*treeCntMat)[i]   = (int*)(calloc((n+1),sizeof(int)));
	}
	*/
	genWords(parentArr, n,treeStateCharMat);
	
	for(i=0;i<N_combinations;i++)
	{
		//fprintf(stdout,"%s\t",treeStateCharMat[i]);
		//fprintf(stdout,"%d:\t",i+1);
		k = validTree(treeStateCharMat[i],parentArr,n);
        // fprintf(stdout,"%d %s\n",k,treeStateCharMat[i]);
		if(k == 1)	
		{	
			//fprintf(stdout,"valid tree\n");
			for(j=0;j<n;j++)
			{
				(*treeStateMat)[*m][j] = (int)(treeStateCharMat[i][j])-97;
				//fprintf(stdout,"%d ",(int)(treeStateCharMat[i][j])-97+1);
                if(j==0)
                {
                    (*treeCntMat)[*m][j] = 0;
                }
                else
                    (*treeCntMat)[*m][j] = findState(treeStateCharMat[i][j]) - findState(treeStateCharMat[i][parentArr[j]-1]); 
			}
			(*m)++;
		}
		else
			;//fprintf(stdout,"invalid tree\n");
			
	}
	//fprintf(stdout,"Number of combinations is %d, and %d of them satisfies the given tree structure. \n",N_combinations, (*m));

	for(i=0;i<N_combinations;i++)
		free(treeStateCharMat[i]);
	free(treeStateCharMat);	

	
}

void cleanGarbage(int*** treeStateMat,int*** treeCntMat,int m2)
{
	int i;
	for(i=0;i<m2;i++)
	{
		free((*treeStateMat)[i]);
		free((*treeCntMat)[i]);
	}
	free(*treeStateMat);	
	free(*treeCntMat);	
}




//main program
int main(int argc, char* argv[])
{
	int L;
	//get the integer array of parents/states from TJ
    if(argc < 2)
    {
	    fprintf(stdout,"input parsing error\n");
    	return -1;
	}
	
    L = strlen(argv[1]);
	// TJ's input/output preparation
    //int parentArr[] = {0, 0, 0, 0, 0};
    int* parentArr;
	parentArr = (int*)(calloc(L,sizeof(int)));
    
    int i;
    for(i=0;i<L;i++)
    {
    	parentArr[i] = (int)argv[1][i] - 48;
	}
    
    //int n = sizeof(parentArr)/sizeof(parentArr[0]);
	int n = L;
    //fprintf(stdout,"number of nodes = %d\n",n);

	// TJ's output preparation	
	int** treeStateMat;
	int** treeCntMat;
	int m_fil = 0;
	int m_tot = 0;
    int N_combinations = 1;

    for(i=0;i<n;i++)
		N_combinations *= strlen(hashTable[parentArr[i]]); 	

	treeStateMat = (int**)(calloc(N_combinations,sizeof(int*)));
	treeCntMat = (int**)(calloc(N_combinations,sizeof(int*)));
	for(i=0;i<N_combinations;i++)
	{		
		treeStateMat[i] = (int*)(calloc((n+1),sizeof(int)));
		treeCntMat[i]   = (int*)(calloc((n+1),sizeof(int)));
	}
	getAllCombinations(parentArr,n,&treeStateMat,&treeCntMat,&m_fil,&m_tot);

	int j;

	fprintf(stdout, "Input. Parent array: %s, number of nodes: %d.\n", argv[1], n);	
	
	fprintf(stdout, "Output. Number of possible combinations: %d. Number of valid combinations: %d.\n", m_tot, m_fil);
	FILE *fp;

	char *output_file; ////???
	output_file = argv[2];	

    fp = fopen(output_file, "w");
    
    fprintf(fp, "n_State:\n");
    fprintf(fp, "%d\n", m_fil);
    fprintf(fp, "\n");
    
    fprintf(fp, "TreeStateMat:\n");
    
	for(i=0;i<m_fil;i++)
	{
		for(j=0;j<n;j++)
        {
			//fprintf(stdout, "%d ", treeStateMat[i][j]);
            fprintf(fp, "%d ", treeStateMat[i][j]);
        } 
		
        //fprintf(stdout, "\n");
        fprintf(fp, "\n");
	}
    //fprintf(stdout, "\n");
    fprintf(fp, "\n");
	
	fprintf(fp, "TreeCntMat:\n");
	for(i=0;i<m_fil;i++)
	{
		for(j=0;j<n;j++)
        {
			//fprintf(stdout,"%d ",treeCntMat[i][j]);
            fprintf(fp,"%d ",treeCntMat[i][j]);
		}
        //fprintf(stdout,"\n");
        fprintf(fp,"\n");
	}


	fclose(fp);
	cleanGarbage(&treeStateMat,&treeCntMat,m_tot);
	fprintf(stdout, "Done. Tree state (and count) matrix saved at %s.\n", output_file);
	free(parentArr);
    return 0;
}

